// CtrlCard.h: interface for the CCtrlCard class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_)
#define AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/*********************** Motion control module ********************
 For simplicity, quickly and easily develop a common good, scalable,
 easy to maintain application systems, 
we in control card based library of all library functions will be classified package.
 The following example uses a motion control card 
****************************************** **************/


#define  MAXAXIS  6    //Maximum number of axes

class CCtrlCard  
{
public:
	int Get_DelayStatus();
	int Setup_Delay(long time);
	int Setup_HardStop(int value, int logic);
	int Setup_Stop1Mode(int axis, int value, int logic);
	int Setup_Stop0Mode(int axis, int value, int logic);
	int Setup_LimitMode(int axis, int value1, int value2, int logic);
	int Setup_PulseMode(int axis, int value);
	void Get_Version(float &LibVer);
	int Setup_Pos(int axis, long pos, int mode);
	int Write_Output(int number, int value);
	int Read_Input(int number);
	int Get_CurrentInf(int axis, long &LogPos, long &ActPos, long &Speed);
	int Get_Status(int axis, int &value, int mode);
	int StopRun(int axis, int mode);

	int Interp_Move6(long pulse1,long pulse2,long pulse3,long pulse4,long pulse5,long pulse6);
	int Interp_Move5(int axis1,int axis2,int axis3,int axis4,int axis5,long pulse1,long pulse2,long pulse3,long pulse4,long pulse5);
	int Interp_Move4(int axis1,int axis2,int axis3,int axis4,long value1, long value2, long value3, long value4);
	int Interp_Move3(int axis1, int axis2, int axis3, long value1, long value2, long value3);
	int Interp_Move2(int axis1, int axis2, long value1, long value2);

	int Axis_Pmove(int axis ,long value);
	int Axis_ConMove(int axis, long value);

	int Setup_Speed(int axis ,long startv ,long speed ,long add ,int mode);
	int Init_Board();
	int Set_IoMode(int v1,int v2);

	int Sym_RelativeMove(int axis, long pulse, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteMove(int axis, long pulse, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_RelativeLine2(int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteLine2(int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_RelativeLine3(int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteLine3(int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteLine4(int axis1,int axis2,int axis3,int axis4,long pulse1, long pulse2, long pulse3,  long pulse4,long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_RelativeLine4(int axis1,int axis2,int axis3,int axis4,long pulse1, long pulse2, long pulse3,  long pulse4,long lspd ,long hspd, double tacc, long vacc, int mode);
	int Get_OutNum(int number);
	int Sym_RelativeLine5(int axis1,int axis2,int axis3,int axis4,int axis5,long pulse1, long pulse2, long pulse3,  long pulse4,long pulse5,long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteLine5(int axis1,int axis2,int axis3,int axis4,int axis5,long pulse1, long pulse2, long pulse3, long pulse4,long pulse5,long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_RelativeLine6(long pulse1, long pulse2, long pulse3,  long pulse4,long pulse5,  long pulse6,long lspd ,long hspd, double tacc, long vacc, int mode);
	int Sym_AbsoluteLine6(long pulse1, long pulse2, long pulse3, long pulse4,long pulse5,  long pulse6,long lspd ,long hspd, double tacc, long vacc, int mode);
    
	int Manu_Pmove(int axis, long pulse);
    int Manu_Continue(int axis);
    int Manu_Disable(int axis);

	int Setup_LockPosition(int axis,int mode,int regi,int logical);
	int Get_LockStatus(int axis,int &v);
	int Get_LockPosition(int axis,long &pos);
	int Clr_LockPosition(int axis);


	CCtrlCard();
	int Result;         //Return Value

};

#endif // !defined(AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_)
